  '  ' ***** uMitePi *****
  ' *******************************
  '    Filename: uMitePi.bas
  '    Date: Aug 2021
  '    File Version:
  '     Written by: M.Ogden
  '    Function: uMitePi controller
  '   Device: micromite mx170
  '    Last Revision:
  '    Initial v0.6
  '   MMBasic Ver 5.05.04 ,raspberry Pi running  Node Red
  'adds some LED indicators, Fan control and Shutdown signaling
  'plus user code
  'V2 PCB adds access to all unused MX170 IO pins, adds RTC connector
  'V0.7 release
  'v0.8 add I/O changes for version 2 PCB
  'v0.9 add standby state retention
  'v1.0 add ups-power
  'v1.1 add prop fan control
  'v1.2 add Nokia LCD v3 Option
  'v1.3 v3.1 pcb, change fan to use PWM2 (Pin26)
  'v1.31 add shutdown-seq , respond to linux shutdown command
  '** Power
  'v1.32 add power flag,errflag & countdown clock
  'v1.33 fix jsonvalue, replace serial interupt mode
 'v1.34p pico updated
  'v1.35p ups management
  'v1.36p Alligned MX170 & Pico versions (apart from Pin#)	
  'v1.36p MX170 SOIC version uses V2 PCB 
  ' *******************************
  'IO Pin List
  'D1 Led (Button)
  'D5 Button
  'D6 rpi-running (sig)
  'D8 rpi-shutdown (out)
  'D9  rpi-poweron (out)
  'D10 ups-nopower (sig)
  'Pin 26 Fan Ctrl  on v3.1 pcb
'
'
'				 
  
  
  dim ver$="1.36m"
  dim integer D1=10,D5=16,D8=15,D6=18,D9=17,d10=5   'mx170 IO pins V3+ pcb
  'Variables
  dim q$=chr$(34),J$="&",temp$="",lastline$,newline$
  'prop temp control
  
  dim ffan=50
  dim fan_cycle=60
  dim temp_run=40
  dim stall_percent=30
  dim temp_max=65
  dim fan_ratio=((99-stall_percent)/(temp_max-temp_run))
  
  ' 
  dim integer secs=0,flag=0 'periods
  dim integer uptime=0  'time up in seconds
  dim integer upspower=0  'ups power on
  dim integer upstime=0 'time on battery
  dim integer upsexpired=60  'time allowed on battery
  dim integer errflag=0 'error
  Dim Integer userprocessflag
  dim integer cdclock=20 ' seconds
  dim rpitemp$="45"
  dim rpiload$
  dim rpidate$,rpitime$,rpiutc$
  dim integer standby,powerflag,powerfail
 
  'periodic triggers
  dim secs5=5
  dim secs10=10
  dim secs20=20
  dim secs60=60
  dim min5=300'5 min in secs
  
  '***** User Variables ******
  dim gridavg=480
  dim pw$,sw$,ot$,oh$,ws$,wg$,wd$,pr$,ra$
  dim sa(6)
  dim sb(6)
  dim sdata=0
  dim sdata1=0
  '***** User Variables ******
  
  setpin d1, dout 'Led 1
  setpin D8, dout 'pi-shutdown
  setpin d9, dout 'pi-poweron
  pin(d8)=1 'pi-shutdown (not-shutdown)
  pin(d1)=0 'Led(button) off
  '  'Inputs
  setpin D5, intl,buttonpress,PULLUP  'S2 Button
  setpin D6, intl,notrunning        'rpi-running
  setpin d10, intb,nopower,pulldown 'ups-nopower
  '*********************************************************************************
  'cls
  Print
  print "mmPi"
  print "ver: "+ver$
  'font 5
  'Text 0,0, "mmPi "+ver$
  'Text 0,8, time$
  'text 0,16, "Temp: "+str$(val(rpitemp$),2,1)
  'initialise
  var restore
  if standby=1 then
    print "Standby"
    cpu 5
    led3 d1,0							
    pin(d9)=1  'shutdown power supply	
    PWM 2,ffan,stop  'off				
  else
      'start up via Power Source check
    if pin(d10)=1 then
      powerflag=1
      startupseq
    end if
  
  
  end if
  
  'debug
  'pin(d9)=0 'take control of power supply On
  'end
  
  randomize 150 'seed the number gen 'MX Only
  'serial Com1
  open "com1:115200" as #5
  settick 1000, T1,1  '1 sec timer
  'settick 60000,runonce,2
  
  'main loop processing
  do
    'looptime=timer
    'print "Loop"
    Watchdog 20000 ' set the WDT at 20 secs
    if standby <>1 then
	  if upstime>upsexpired then shutdownseq
      'if upstime>some-triggerpoint then some-event
      'eg close down some other server									  
      rec1
      '***** periodic processes *****
      if secs10=0 then
        secs10=10
        adjFanSpeed val(rpitemp$)
        '***** User Code *****
        if pw$ <> "" then
          upower=val(pw$)
          gridpower
        end if
        if sw$ <> "" then
          spower=val(sw$)
        end if
        'print rpidate$;" ";rpitime$
        '***** User Code *****
      end if
      
      if secs5=0 then
        secs5=5
		 '***** User Code *****
        print#5,"{"+q$+"powerflag"+q$+":"+str$(powerflag)+"}"
      end if
      
      if secs60=0 then
        secs60=60
		 '***** User Code *****
        pws
      end if
      
      if min5=0 then
        min5=300
		 '***** User Code *****
       
      end if
      
    else
      'standby only
    end if
    ' Print "Elapsed:";timer-looptime/1000
  loop
  
  
  'core routines
sub runonce
  settick 0,0,2 'disable timer
end sub 
  
	  'power plug interupt				  
sub nopower
  if pin(d10)=1 then
    print "Power OK"
    powerflag=1
 if powerfail=1 then startupseq  'only start if in standby															 
  else
    print "Power Disconnected"
	 pause 1000
    print "UPS Power"
    if standby =0 then
      print "Will close down in ";upsexpired;" secs"
      powerfail=1		  
    powerflag=0
	upstime=0 'reset time					   
	 end if	  
  end if
end sub
  
sub notrunning
  print "Pi Notrunning"
  shutdownseq
end sub
  
  'Heartbeat
sub T1
  if standby=0  then  'normal running
    'print "Countdown:";cdclock
    if secs5>0 then secs5=secs5-1
    if secs10>0 then secs10=secs10-1
    if secs20>0 then secs20=secs20-1
    if secs60>0 then secs60=secs60-1
    if min5>0 then min5=min5-1
    if cdclock>0 then
      led3 d1,1 'Power Led On
      errflag=0 'reset the flag
      cdclock=cdclock-1 'countdown clock decrement
    else
      errflag=1 'set the error flag
    end if
    uptime=uptime+1 'time while running

     else      'in standby or No Power
  endif
	 if powerflag=0 then upstime=upstime+1 'time in disconnected and ups
  if errflag=1 then led2 d1
  'print "Uptime:";uptime;" upstime:";upstime			 
end sub
  
  
  'Led1 pulse p=pin
sub led1(p,d)
  if d=0 then d=50
  pulse p,d
end sub
  
  'Led2 toggle
sub led2(p)
  if pin(p)=1 then
    pin(p)=0
  else
    pin(p)=1
  end if
end sub
  
  'Led3 set
sub led3(p,hl)
  pin(p)=hl
end sub
  
  # Set the PWM of fan pin
sub adjFanSpeed(CPU_temp)
  if  CPU_temp > temp_run then
    FAN_cycle = (((CPU_temp - temp_run)*fan_ratio)+stall_percent)
    FAN_cycle = min(100,max(stall_percent,FAN_cycle))
    PWM 2,ffan,fan_cycle
  else
    PWM 2,ffan,stop  'off
    FAN_cycle=0
  end if
end sub
  
  
Sub rec1
  'reads bytes from comms buffer , data terminated by CR will output a NewLine$ and set the UserFlag
  'if userprocessflag=1 then exit sub
  local a$
  local integer p,l,i
  'print "Buffer:";loc(5)
  if len(a$)=>235 then
    i=255-len(a$)
  else
    i=20
  endif
  'print "i:";i
  a$=Input$(i,#5)  'user supplied processing routine
  'pause 100
  'print a$;
  on error skip 'DEBUG
  lastline$=lastline$ + a$    'add to data packet 'DEBUG
  'print lastline$
packet:
  l=len(lastline$)
  p=instr(lastline$,chr$(13))
  '  print
  '  print "Line Lenght:";l
  '  print "CR?:";p
  '  print "Buffer:";loc(5)
  '  print lastline$
  '  print newline$
  '  print
  
  if l=>235 and p=0 then   'long line and no CR
    'force line to be processed
    newline$=lastline$
    lastline$=""
    userprocess 'force data process
    exit sub
  end if
  
  if p>0 then   'CR found so process
    'lastline$=replace$(lastline$,chr$(10),"")  'remove LF
    Newline$=left$(Lastline$,p-1)
    'check comms using temperature string from Pi
    'if good reset the countdown clock
    if instr(newline$,"{"+q$+"pi-temp"+q$+":")>0 then cdclock=20
    if l>p+1 then
      lastline$=mid$(lastline$,p+1) 'save the rest of the line
    else
      lastline$=""
    end if
    'recover standard data pairs from Pi
	print "Process:";newline$						 
    getjson newline$,rpitemp$,"pi-temp"
    getjson newline$,rpiload$,"usage"
    getjson newline$,rpidate$,"Date"
    getjson newline$,rpitime$,"Time"
    getjson newline$,rpiutc$,"DateUTC"
   'recover any User program data pairs
    'uncomment next line as required
    userprocess
  endif
End Sub
  
sub buttonpress
  pause 50  'debounce
  if pin(d5)=0 then presstime
end sub
  
sub presstime
  pause 1000
  if pin(d5)=0 then
    if pin(d6)=1 then   'is pi running
     
      shutdownseq
    else
	 'start up via Power Source check
      if pin(d10)=1 then
        powerflag=1						  
      startupseq
		end if	
    end if
  else
    print "shortpress"
    led1 d1,100
  end if
end sub
  
sub shutdownseq
  Watchdog 20000 ' set the WDT at 20 secs
  print "Shutdown"
  led1 d1,1000
  pin(d8)=0  'shutdown RPI
  pause 1000
  pin(d8)=1
	print "Standby"
  errflag=0
  standby=1			 
  pause 15000' Wait for pi to shutdown
  led3 d1,0
  print "shutdown supply"
  pin(d9)=1  'shutdown power supply
  PWM 2,ffan,stop  'off
  
  var save standby,powerfail
  cpu 5
end sub
  
sub startupseq
  print "Startup"
	print "Running"			 
  cpu 48
  led1 d1,1000
	 uptime=0
  pin(d9)=0  'power supply on						   
  uptime=0
   upstime=0
  standby=0
 powerfail=0			 
  var save standby,powerfail
  pause 2000
  led3 d1,1
  PWM 2,ffan,55 'Run fan default
end sub
  
  
function jsonValue$(Jstring$,jParam$)
  local a,c,s$,d$,b,json$
  json$=jstring$
  s$=":"
  d$=","
  'locate parameter
   a=instr(JSON$,jparam$)
  'print "A is:";a
  json$=replace$(json$,chr$(34),"")  'strip quotes
  json$=replace$(json$,"}",",")  'replace closing curly brackets with comma
  if a>0 then 'retrieve value
    'look for separator :
    b=instr(a,json$,s$)
    if b>0 then
      'look for deliminator
      c=instr(b,JSON$,d$)
      if c>0 then
        jsonvalue$=mid$(JSON$,b+1,c-(b+1))
      endif
    endif
  else
    jsonvalue$="not found"
  endif
end function
  
  'gjson$ checks for w$ in a json string j$
  'replaces contents of r$ if found
sub getjson(j$,r$,w$)
  local x$
  'print "getjson:";j$
  x$=jsonvalue$(j$,w$)
  if x$ <> "not found" then
    r$=x$
  end if
end sub
  
  'replaceString$(string$, replaceWhat$, replaceWith$)
FUNCTION REPLACE$(R$, a$, b$)
  local integer i,j,c,d
  d=1
  REPLACE$=R$
  i = LEN(a$) : j = LEN(b$)
  do while INSTR(d,REPLACE$, a$) > 0
    c = INSTR(d,REPLACE$, a$)
    REPLACE$ = LEFT$(REPLACE$, c-1) + b$ + MID$(REPLACE$, c+i)
    d = c+j
  loop
END FUNCTION
  
  '**************** End Core routines and functions ********
  '
  'user subs and tasks
  '*** Extra User subs and other code here ***
 
  'process json strings from RPI
Sub userprocess
  print "Process:";newline$
  
end sub
  
  
 
  
  
  
  
  
  
  'End user subs and tasks